/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.api.IOwnable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.DataSerializerEntry;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Owner {
    @GameRegistry.ObjectHolder(value="securitycraft:owner")
    public static final DataSerializerEntry SERIALIZER = null;
    private String ownerName = "owner";
    private String ownerUUID = "ownerUUID";
    private boolean validated = true;

    public Owner() {
    }

    public Owner(Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            this.ownerName = player.func_70005_c_();
            this.ownerUUID = player.func_146103_bH().getId().toString();
        }
    }

    public Owner(EntityPlayer player) {
        if (player != null) {
            this.ownerName = player.func_70005_c_();
            this.ownerUUID = player.func_146103_bH().getId().toString();
        }
    }

    public Owner(String playerName, String playerUUID) {
        this.ownerName = playerName;
        this.ownerUUID = playerUUID;
    }

    public Owner(String playerName, String playerUUID, boolean validated) {
        this.ownerName = playerName;
        this.ownerUUID = playerUUID;
        this.validated = validated;
    }

    public static Owner fromCompound(NBTTagCompound tag) {
        Owner owner = new Owner();
        if (tag != null) {
            owner.load(tag);
        }
        return owner;
    }

    public void load(NBTTagCompound tag) {
        if (tag.func_74764_b("owner")) {
            this.ownerName = tag.func_74779_i("owner");
        }
        if (tag.func_74764_b("ownerUUID")) {
            this.ownerUUID = tag.func_74779_i("ownerUUID");
        }
        if (tag.func_74764_b("ownerValidated")) {
            this.validated = tag.func_74767_n("ownerValidated");
        }
    }

    public void save(NBTTagCompound tag, boolean saveValidationStatus) {
        tag.func_74778_a("owner", this.ownerName);
        tag.func_74778_a("ownerUUID", this.ownerUUID);
        if (saveValidationStatus) {
            tag.func_74757_a("ownerValidated", this.validated);
        }
    }

    public boolean owns(IOwnable ... ownables) {
        for (IOwnable ownable : ownables) {
            if (ownable == null || ownable.isOwnedBy(this)) continue;
            return false;
        }
        return true;
    }

    public boolean isDefaultOwner() {
        return this.equals(new Owner());
    }

    public void set(String uuid, String name) {
        this.ownerName = name;
        this.ownerUUID = uuid;
    }

    public void setOwnerName(String name) {
        this.ownerName = name;
    }

    public void setOwnerUUID(String uuid) {
        this.ownerUUID = uuid;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    public String getName() {
        return this.ownerName;
    }

    public String getUUID() {
        return this.ownerUUID;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public String toString() {
        return "Name: " + this.ownerName + "  UUID: " + this.ownerUUID;
    }

    public Owner copy() {
        return new Owner(this.ownerName, this.ownerUUID);
    }

    @Deprecated
    public boolean equals(Object obj) {
        return obj instanceof Owner && this.getName().equals(((Owner)obj).getName()) && this.getUUID().equals(((Owner)obj).getUUID());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.ownerName).append((Object)this.ownerUUID).build();
    }

    public static DataSerializer<Owner> getSerializer() {
        return SERIALIZER.getSerializer();
    }
}

